/* filter script to reject virus mails from SOBIG.F */
PARSE ARG MessageFile NameFile

/* to save time, only scan the first portion of the message */
/* you can increase this number if you need to              */
MaxLines = 250

/* enables silent deletes (sender thinks mail was successful */
/* but you will not receive it... note, if any legitimate    */
/* messages are accidently caught with this option set, no   */
/* one will know about it)                                   */
SilentDeletes = 1

/* the third option is to have virus e-mails forwarded to a  */
/* particular address for later sorting and deleteion        */
CaptureVirusMails = 1
CaptureAddress = "infected@localhost"

/* load system functions */
CALL RxFuncAdd SysLoadFuncs, rexxutil, sysloadfuncs
CALL SysLoadFuncs

/* read in the mail message */
LineCount = 0
MessageText = ""
DO WHILE (LINES(MessageFile) & (LineCount < MaxLines))
    NextLine = LINEIN(MessageFile)
    MessageText = MessageText || "0D"x || "0A"x || NextLine 
    LineCount = LineCount + 1
END
RC = LINEOUT(MessageFile)

/* if the mail is ok, we will ask weasel to send it normally */
FilterReturnCode = 0

/* set the default rejection message */
RejectionMessage = "554 Mail rejected by server; possible virus detected"

/* look for SOBIG.F and reject it or delete it silently */
IF (POS('the attached file', MessageText) > 0) THEN DO
   IF (POS('Subject: Your details', MessageText) > 0) | (POS('Subject: Thank you!', MessageText) > 0) | (POS('Subject: Re: Thank you!', MessageText) > 0) | (POS('Subject: Re: Details', MessageText) > 0) | (POS('Subject: Re: Re: My details', MessageText) > 0) | (POS('Subject: Re: Approved', MessageText) > 0) | (POS('Subject: Re: Your application', MessageText) > 0) | (POS('Subject: Re: Wicked screensaver', MessageText) > 0) | (POS('Subject: Wicked screensaver', MessageText) > 0) | (POS('Subject: Re: That movie', MessageText) > 0) THEN DO
      IF (POS('.pif', MessageText) > 0) | (POS('.scr', MessageText) > 0) THEN DO

         /* rejection notice sent by default */
         FilterReturnCode = 4

         /* mail silently deleted with no warning to anyone */
         IF SilentDeletes = 1 THEN DO
            FilterReturnCode = 2
         END         

         /* forwards infected mails to a specific mailbox for later sorting */
         /* change your mail delivery agent below if you need */
         IF CaptureVirusMails = 1 THEN DO
             FilterReturnCode = 1
             OriginalSender = LINEIN(NameFile)
             RC = LINEOUT(NameFile)
             RC = SysFileDelete(NameFile)
             RC = LINEOUT(NameFile, OriginalSender)
             RC = LINEOUT(NameFile, CaptureAddress)
             RC = LINEOUT(NameFile)
         END          

      END
   END
END

/* look for stupid warnings from NAV and AVF...                                 */
/* yes, this may generate a bounce, but then maybe the administrator of the     */
/* server who is sending the erroneous warnings will get a clue and turn it off */
/* if you don't want the filter to do this, change the FilterReturnCode to 2    */
IF (POS('Subject: Symantec AVF detected a repairable/quarantined virus in a message you sent', MessageText) > 0) THEN DO
    FilterReturnCode = 4
    RejectionMessage = "554 Mail rejected by server; please do not send virus warnings for viruses that use forged senders. For help configuring your server go to http://www.symantec.com/techsupp/"
END

IF (POS('Subject: Norton AntiVirus detected a virus in a message you sent.  The inf', MessageText) > 0) THEN DO
    FilterReturnCode = 4
    RejectionMessage = "554 Mail rejected by server; please do not send virus warnings for viruses that use forged senders. For help configuring your server go to http://www.symantec.com/techsupp/"
END

IF (POS('Subject: Virus Detected by Network Associates, Inc. Webshield ', MessageText) > 0) THEN DO
    FilterReturnCode = 4
    RejectionMessage = "554 Mail rejected by server; please do not send virus warnings for viruses that use forged senders. For help configuring your server go to http://www.nai.com/us/support/"
END

/* overwrite the namefile with a more meaningful error message */
IF FilterReturnCode = 4 THEN DO
    RC = LINEOUT(NameFile, RejectionMessage, 1)
    RC = LINEOUT(NameFile)
END

/* exit filter */
EXIT FilterReturnCode

